//fevent_demo.c
//This demo shows how to trap pen and key events with the Fevent() call.

library "PToolboxLib"
include "Fctl.h"

#define MAINFORM 3000
#define BUTTON1  3001
#define FIELD1   3002

int x; //global variable for holding X pen position
int y; //global variable for holding Y pen position
char c; //global variable for holding last key character entered

main() {
  int e;
  int prev_x, prev_y;  
  Fctl(BINDX,&x); //bind x variable to receive X pen positions
  Fctl(BINDY,&y); //bind y variable to receive Y pen positions
  Fctl(BINDKEY,&c); //bind c variable to receive key characters
  
  Form(MAINFORM,"Fevent Demo");
  Button(BUTTON1,0,3,145,0,0,"Done");
  Field(FIELD1,0,3,20,80,80,256,"");
  Fctl(DRAW,3000);
  frame(1,119,20,128,31,0);  //draw small box
  frame(1,80,100,155,150,0); //draw large box
  text(90,120,"Drag Pen Here");
  
  while(1) {
    e=Fevent(1);
    switch(e) {
      case 1: //key event
        rect(0,119,20,128,31,0); //clear out small box
        text(120,20,c); //display character entered
        break;
      case 2: //pen down
        //check if point fell in large box
        if(x>80 && x<155 && y>100 && y<150) {
          prev_x = x;
          prev_y = y;
          SetPixel(x,y);
        }
        break;  
      case 4: //pen move
        //check if point fell in large box
        if(x>80 && x<155 && y>100 && y<150) {
          line(1,x,y,prev_x,prev_y);
          prev_x = x;
          prev_y = y;
        }
        break;         
      case 3001: //done button
        return;
    }
  }
}